/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.tabbedPane;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWTabButton;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWTabButtonPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class VWCustomTabbedPane
extends JPanel
implements ActionListener,
KeyListener {
    public static final int TYPE_BORDERS = 0;
    public static final int TYPE_PLAIN = 1;
    protected EventListenerList m_changeListeners = null;
    protected int m_nType = 0;
    protected Vector m_buttonList = null;
    protected VWTabButtonPanel m_buttonPanel = null;
    protected ButtonGroup m_buttonGrp = null;
    protected CardLayout m_cardLayout = null;
    protected JPanel m_cardLayoutPanel = null;

    public VWCustomTabbedPane(int nType) {
        this.m_nType = nType;
        this.m_buttonList = new Vector();
        this.createControls();
    }

    public void addTab(String title, Component component) {
        if (title == null || title.length() == 0 || component == null) {
            return;
        }
        VWTabButton newTabButton = new VWTabButton(title, this.m_nType);
        this.m_buttonPanel.add(newTabButton);
        this.m_buttonList.addElement(newTabButton);
        this.m_buttonGrp.add(newTabButton);
        newTabButton.addActionListener(this);
        newTabButton.addKeyListener(this);
        component.setName(title);
        this.m_cardLayoutPanel.add(component, title);
        if (this.m_buttonList.size() == 1) {
            newTabButton.doClick();
        }
    }

    public void insertTab(String title, Icon icon, Component component, String tip, int nIndex) throws IndexOutOfBoundsException {
        if (nIndex < 0 || nIndex >= this.m_buttonList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (title == null || title.length() == 0 || component == null) {
            return;
        }
        int nSelectedIndex = this.getSelectedIndex();
        VWTabButton newTabButton = new VWTabButton(title, this.m_nType);
        this.m_buttonList.insertElementAt(newTabButton, nIndex);
        this.m_buttonGrp.add(newTabButton);
        newTabButton.addActionListener(this);
        newTabButton.addKeyListener(this);
        component.setName(title);
        this.m_cardLayoutPanel.add(component, title);
        this.m_buttonPanel.removeAll();
        for (int nCount = 0; nCount < this.m_buttonList.size(); ++nCount) {
            VWTabButton tabButton = (VWTabButton)this.m_buttonList.elementAt(nCount);
            this.m_buttonPanel.add(tabButton);
        }
        this.setSelectedIndex(nSelectedIndex);
    }

    public void removeTabAt(int nIndex) throws IndexOutOfBoundsException {
        if (nIndex < 0 || nIndex >= this.m_buttonList.size()) {
            throw new IndexOutOfBoundsException();
        }
        VWTabButton tabButton = (VWTabButton)this.m_buttonList.elementAt(nIndex);
        tabButton.removeActionListener(this);
        tabButton.removeKeyListener(this);
        this.m_buttonPanel.remove(tabButton);
        this.m_buttonList.removeElement(tabButton);
        this.m_buttonGrp.remove(tabButton);
        String title = tabButton.getText();
        Component[] components = this.m_cardLayoutPanel.getComponents();
        for (int nPanelIndex = 0; nPanelIndex < components.length; ++nPanelIndex) {
            if (VWStringUtils.compare(components[nPanelIndex].getName(), title) != 0) continue;
            this.m_cardLayoutPanel.remove(components[nPanelIndex]);
            break;
        }
    }

    public int getSelectedIndex() {
        for (int nIndex = 0; nIndex < this.m_buttonList.size(); ++nIndex) {
            VWTabButton newTabButton = (VWTabButton)this.m_buttonList.elementAt(nIndex);
            if (!newTabButton.isSelected()) continue;
            return nIndex;
        }
        return -1;
    }

    public void setSelectedIndex(int nIndex) throws IndexOutOfBoundsException {
        if (nIndex < 0 || nIndex >= this.m_buttonList.size()) {
            throw new IndexOutOfBoundsException();
        }
        VWTabButton tabButton = (VWTabButton)this.m_buttonList.elementAt(nIndex);
        tabButton.requestFocusInWindow();
        tabButton.doClick();
    }

    public int getTabCount() {
        return this.m_buttonList.size();
    }

    public int indexOfTab(String title) {
        for (int nIndex = 0; nIndex < this.m_buttonList.size(); ++nIndex) {
            VWTabButton tabButton = (VWTabButton)this.m_buttonList.elementAt(nIndex);
            if (tabButton == null || VWStringUtils.compare(title, tabButton.getText()) != 0) continue;
            return nIndex;
        }
        return -1;
    }

    public String getTitleAt(int nIndex) throws IndexOutOfBoundsException {
        if (nIndex < 0 || nIndex >= this.m_buttonList.size()) {
            throw new IndexOutOfBoundsException();
        }
        VWTabButton tabButton = (VWTabButton)this.m_buttonList.elementAt(nIndex);
        return tabButton.getText();
    }

    public void addChangeListener(ChangeListener listener) {
        if (this.m_changeListeners == null) {
            this.m_changeListeners = new EventListenerList();
        }
        this.removeChangeListener(listener);
        this.m_changeListeners.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        if (this.m_changeListeners != null) {
            this.m_changeListeners.remove(ChangeListener.class, listener);
        }
    }

    public void releaseReferences() {
        if (this.m_changeListeners != null) {
            Object[] listeners = this.m_changeListeners.getListenerList();
            if (listeners != null) {
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ChangeListener.class) continue;
                    this.removeChangeListener((ChangeListener)listeners[i]);
                }
            }
            this.m_changeListeners = null;
        }
        if (this.m_buttonList != null) {
            for (int nIndex = 0; nIndex < this.m_buttonList.size(); ++nIndex) {
                VWTabButton tabButton = (VWTabButton)this.m_buttonList.elementAt(nIndex);
                tabButton.removeActionListener(this);
                tabButton.removeKeyListener(this);
            }
            this.m_buttonList.removeAllElements();
            this.m_buttonList = null;
        }
        if (this.m_buttonPanel != null) {
            this.m_buttonPanel.removeAll();
            this.m_buttonPanel = null;
        }
        this.m_buttonGrp = null;
        this.m_cardLayout = null;
        if (this.m_cardLayoutPanel != null) {
            this.m_cardLayoutPanel.removeAll();
            this.m_cardLayoutPanel = null;
        }
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof VWTabButton) {
            String name = ((VWTabButton)source).getText();
            this.m_cardLayout.show(this.m_cardLayoutPanel, name);
        }
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        if ((event.getModifiers() & 1) != 0) {
            return;
        }
        switch (event.getKeyCode()) {
            case 39: 
            case 227: {
                int nSelectedIndex = this.getSelectedIndex();
                nSelectedIndex = nSelectedIndex == this.getTabCount() - 1 ? 0 : ++nSelectedIndex;
                this.setSelectedIndex(nSelectedIndex);
                break;
            }
            case 37: 
            case 226: {
                int nSelectedIndex = this.getSelectedIndex();
                nSelectedIndex = nSelectedIndex == 0 ? this.getTabCount() - 1 : --nSelectedIndex;
                this.setSelectedIndex(nSelectedIndex);
                break;
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    protected void createControls() {
        this.setLayout(new BorderLayout());
        this.m_buttonPanel = new VWTabButtonPanel((LayoutManager)new FlowLayout(3, 0, 0), this.m_nType);
        this.add((Component)this.m_buttonPanel, "First");
        this.m_buttonGrp = new ButtonGroup();
        this.m_cardLayout = new CardLayout();
        this.m_cardLayoutPanel = new JPanel(this.m_cardLayout);
        this.add((Component)this.m_cardLayoutPanel, "Center");
    }

    protected void fireStateChanged() {
        try {
            if (this.m_changeListeners != null && this.m_changeListeners.getListenerCount() > 0) {
                Object[] listeners = this.m_changeListeners.getListenerList();
                ChangeEvent event = new ChangeEvent(this);
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != ChangeListener.class) continue;
                    ((ChangeListener)listeners[i + 1]).stateChanged(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

